IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_CleverAPI_Ejecutar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_CleverAPI_Ejecutar
END
GO

CREATE PROCEDURE [dbo].[CPJ_CleverAPI_Ejecutar] @pJson VARCHAR(8000)
AS 

/*
 * LOG VERSIONES:
 * 22/08/2022: Se crea el Stored
*/

/*-------------------------------------------------------------------------------------------------------------------------------------*/

/*
NOTA IMPORTANTE:

Para utilizar este Stored primero se debe haber configurado el motor de SQL a traves del Stored: CP_ConfigurarMSSQL
*/

/*-------------------------------------------------------------------------------------------------------------------------------------*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug				TINYINT
DECLARE @pAPI_URL				VARCHAR(255)
DECLARE @pAPI_Metodo			VARCHAR(255)
DECLARE @pAPI_Data				VARCHAR(8000)
DECLARE @pAPI_Token				VARCHAR(50)
DECLARE @pAPI_Base_Datos		VARCHAR(100)

SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pAPI_URL					= ISNULL(CONVERT(VARCHAR(255), dbo.CF_JSON_VALUE(@pJson,'API_URL')),'')
SET @pAPI_Metodo				= ISNULL(CONVERT(VARCHAR(255), dbo.CF_JSON_VALUE(@pJson,'API_Metodo')),'')
SET @pAPI_Data					= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'API_Data')),'')
SET @pAPI_Token					= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'API_Token')),'')
SET @pAPI_Base_Datos			= ISNULL(CONVERT(VARCHAR(255), dbo.CF_JSON_VALUE(@pJson,'API_Base_Datos')),'')
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @Obj_Token 		INT
DECLARE @Respuesta		VARCHAR(8000)
DECLARE @Body			VARCHAR(8000)
DECLARE @Estado_Html	INT
/*FIN Variables Locales*/

IF(@pModoDebug = 1)
BEGIN
	PRINT 'Ingreso a Stored Procedure: CPJ_CleverAPI_Ejecutar'
	PRINT 'Parametros:'
	PRINT 'pAPI_URL: ' + @pAPI_URL  + '. pAPI_Token: ' + @pAPI_Token
	PRINT 'pAPI_Metodo: ' + @pAPI_Metodo 
	PRINT 'pAPI_Data: ' + @pAPI_Data 
	PRINT 'pAPI_Base_Datos: ' + @pAPI_Base_Datos
	PRINT ''
END

/*-------------------------------------------------------------------------------------------------------------------------------------*/

IF(@pAPI_Metodo = '')	RAISERROR ('El parametro: API_Metodo no puede estar vacio.', 16,  1 )

IF(@pAPI_Data = '')		RAISERROR ('El parametro: API_Data no puede estar vacio.', 16,  1 )

IF(@pAPI_URL = '')
BEGIN
	SET @pAPI_URL = dbo.CF_xParam('API_Url')
END

IF(@pAPI_Token = '')
BEGIN
	SET @pAPI_Token = dbo.CF_xParam('Api_Token')
END

IF(@pAPI_Base_Datos = '')
BEGIN
	SET @pAPI_Base_Datos = DB_NAME()
END

/*-------------------------------------------------------------------------------------------------------------------------------------*/

SET @Body = @pAPI_Metodo + '=1'
SET @Body = @Body + '&' + 'data=' + '{' + @pAPI_Data + '}'
SET @Body = @Body + '&' + 'token=' + @pAPI_Token
SET @Body = @Body + '&' + 'db=' + @pAPI_Base_Datos

IF(@pModoDebug = 1)
BEGIN
	PRINT '@Body: ' + @Body
END

/*-------------------------------------------------------------------------------------------------------------------------------------*/

EXEC SP_OACreate 'WinHttp.WinHttpRequest.5.1', @Obj_Token OUT;
IF @Obj_Token <> 0 RAISERROR('ERROR CPJ_CleverAPI_Ejecutar: No pudo conectarse al servidor.', 10, 1);

EXEC SP_OAMethod @Obj_Token, 'open', NULL, 'POST', @pAPI_URL, 'false'
IF @Obj_Token <> 0 RAISERROR('ERROR CPJ_CleverAPI_Ejecutar: No se pudo abrir la conexion.', 10, 1);

EXEC SP_OAMethod @Obj_Token, 'setRequestHeader', null, 'Content-Type', 'application/x-www-form-urlencoded'

EXEC SP_OAMethod @Obj_Token, 'send', NULL, @Body

EXEC SP_OAGetProperty @Obj_Token, 'status', @Estado_Html OUTPUT
EXEC SP_OAGetProperty  @Obj_Token, 'responseText', @Respuesta OUTPUT

EXEC SP_OADestroy @Obj_Token

/*-------------------------------------------------------------------------------------------------------------------------------------*/

SELECT 
@Respuesta			AS Respuesta,
@Estado_Html		AS Rta_Estado 

/*-------------------------------------------------------------------------------------------------------------------------------------*/

/*
EXEC dbo.CPJ_CleverAPI_Ejecutar '{"ModoDebug":"0", "API_URL":"http://clubamigos.homeip.net:10880/api2/", "API_Metodo":"CP_SCA_RegistrarAcceso_SinGrabado", "API_Data":{"pId_Controlador":"87","pTipoAcceso":"E","pFecha":"2022-08-22T08:23:00","pFechaEvento":"19000101","pTag":"D4340230","pDoc":"0","pHue":"","pCba":"","pDma":"","pFlag_Permite_Paso":"0"}, "API_Token":"dkprq0ihmDJRjOWhyrJfUXjepydGzCxP", "API_Base_Datos":"ISIS_Club"}'

EXEC dbo.CPJ_CleverAPI_Ejecutar '{"ModoDebug":"1", "API_URL":"http://localhost:10880/api2/", "API_Metodo":"CP_SCA_RegistrarAcceso_SinGrabado", "API_Data":{"pId_Controlador":"87","pTipoAcceso":"E","pFecha":"2022-08-22T08:23:00","pFechaEvento":"19000101","pTag":"D4340230","pDoc":"0","pHue":"","pCba":"","pDma":"","pFlag_Permite_Paso":"0"}, "API_Token":"gOiCCbesES1sORCe6rborRTttCqw4Sde", "API_Base_Datos":"PLATENSE_Clever_Platense"}'

EXEC dbo.CPJ_CleverAPI_Ejecutar '{"ModoDebug":"1", "API_URL":"http://clubamigos.homeip.net:10880/api2/", "API_Token":"dkprq0ihmDJRjOWhyrJfUXjepydGzCxP", "API_Base_Datos":"ISIS_Club", "API_Metodo":"suprema_rf_validate", "API_Data":{"id_cliente":"85977"}}'
*/
